

<?php $__env->startSection('title', 'Pengeluaran'); ?>
<?php $__env->startSection('subtitle', 'Kelola transaksi pengeluaran'); ?>

<?php $__env->startSection('content'); ?>
<!-- Summary -->
<div class="bg-gradient-to-br from-rose-500 via-rose-600 to-pink-700 rounded-2xl p-8 mb-8 shadow-soft-lg relative overflow-hidden">
    <div class="absolute top-0 right-0 w-48 h-48 bg-white/10 rounded-full -mr-24 -mt-24"></div>
    <div class="absolute bottom-0 left-0 w-32 h-32 bg-rose-400/20 rounded-full -ml-16 -mb-16"></div>
    <div class="relative">
        <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-6">
            <div>
                <p class="text-rose-100 font-medium mb-2">Total Pengeluaran (Approved)</p>
                <p class="text-4xl font-bold text-white">Rp <?php echo e(number_format($totalApproved ?? 0, 0, ',', '.')); ?></p>
            </div>
            <a href="<?php echo e(route('expense.create')); ?>" 
               class="inline-flex items-center px-6 py-3 bg-white text-rose-700 font-bold rounded-xl hover:bg-rose-50 transition-all shadow-lg">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                </svg>
                Tambah Pengeluaran
            </a>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="bg-white rounded-2xl shadow-soft border border-gray-100/50 p-5 mb-6">
    <form action="<?php echo e(route('expense.index')); ?>" method="GET" class="grid grid-cols-1 md:grid-cols-6 gap-4">
        <div>
            <label class="block text-xs font-bold text-gray-400 uppercase tracking-wider mb-2">Kategori</label>
            <select name="category_id" class="w-full border-gray-200 rounded-xl text-sm py-2.5">
                <option value="">Semua</option>
                <?php $__currentLoopData = $categories ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($cat->id); ?>" <?php echo e(request('category_id') == $cat->id ? 'selected' : ''); ?>><?php echo e($cat->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div>
            <label class="block text-xs font-bold text-gray-400 uppercase tracking-wider mb-2">Unit</label>
            <select name="business_unit_id" class="w-full border-gray-200 rounded-xl text-sm py-2.5">
                <option value="">Semua</option>
                <?php $__currentLoopData = $businessUnits ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($unit->id); ?>" <?php echo e(request('business_unit_id') == $unit->id ? 'selected' : ''); ?>><?php echo e($unit->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div>
            <label class="block text-xs font-bold text-gray-400 uppercase tracking-wider mb-2">Status</label>
            <select name="status" class="w-full border-gray-200 rounded-xl text-sm py-2.5">
                <option value="">Semua</option>
                <option value="draft" <?php echo e(request('status') == 'draft' ? 'selected' : ''); ?>>Draft</option>
                <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                <option value="approved" <?php echo e(request('status') == 'approved' ? 'selected' : ''); ?>>Approved</option>
            </select>
        </div>
        <div>
            <label class="block text-xs font-bold text-gray-400 uppercase tracking-wider mb-2">Dari</label>
            <input type="date" name="start_date" value="<?php echo e(request('start_date')); ?>" class="w-full border-gray-200 rounded-xl text-sm py-2.5">
        </div>
        <div>
            <label class="block text-xs font-bold text-gray-400 uppercase tracking-wider mb-2">Sampai</label>
            <input type="date" name="end_date" value="<?php echo e(request('end_date')); ?>" class="w-full border-gray-200 rounded-xl text-sm py-2.5">
        </div>
        <div class="flex items-end gap-2">
            <button type="submit" class="flex-1 px-4 py-2.5 bg-slate-800 text-white text-sm font-semibold rounded-xl hover:bg-slate-900">Filter</button>
            <a href="<?php echo e(route('expense.index')); ?>" class="px-3 py-2.5 border border-gray-200 text-gray-500 rounded-xl hover:bg-gray-50">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                </svg>
            </a>
        </div>
    </form>
</div>

<!-- Table -->
<div class="bg-white rounded-2xl shadow-soft border border-gray-100/50 overflow-hidden">
    <div class="overflow-x-auto">
        <table class="w-full">
            <thead class="bg-gray-50/80">
                <tr>
                    <th class="text-left py-4 px-6 text-xs font-bold text-gray-400 uppercase">No. Transaksi</th>
                    <th class="text-left py-4 px-6 text-xs font-bold text-gray-400 uppercase">Tanggal</th>
                    <th class="text-left py-4 px-6 text-xs font-bold text-gray-400 uppercase">Kategori</th>
                    <th class="text-left py-4 px-6 text-xs font-bold text-gray-400 uppercase">Keterangan</th>
                    <th class="text-left py-4 px-6 text-xs font-bold text-gray-400 uppercase">Status</th>
                    <th class="text-right py-4 px-6 text-xs font-bold text-gray-400 uppercase">Jumlah</th>
                    <th class="text-center py-4 px-6 text-xs font-bold text-gray-400 uppercase">Aksi</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-50">
                <?php $__empty_1 = true; $__currentLoopData = $transactions ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="table-row-hover">
                    <td class="py-4 px-6">
                        <div class="flex items-center">
                            <div class="w-10 h-10 bg-rose-100 rounded-xl flex items-center justify-center mr-3">
                                <svg class="w-5 h-5 text-rose-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 13l-5 5m0 0l-5-5m5 5V6"/>
                                </svg>
                            </div>
                            <span class="text-sm font-semibold text-gray-800"><?php echo e($trx->transaction_number); ?></span>
                        </div>
                    </td>
                    <td class="py-4 px-6 text-sm text-gray-600"><?php echo e($trx->date->format('d M Y')); ?></td>
                    <td class="py-4 px-6">
                        <span class="px-3 py-1.5 bg-gray-100 text-gray-600 text-xs font-semibold rounded-lg"><?php echo e($trx->category?->name ?? '-'); ?></span>
                    </td>
                    <td class="py-4 px-6 text-sm text-gray-600 max-w-xs truncate"><?php echo e($trx->description); ?></td>
                    <td class="py-4 px-6">
                        <span class="inline-flex items-center px-3 py-1.5 rounded-lg text-xs font-semibold
                            <?php echo e($trx->status == 'approved' ? 'bg-emerald-100 text-emerald-700' : ''); ?>

                            <?php echo e($trx->status == 'pending' ? 'bg-amber-100 text-amber-700' : ''); ?>

                            <?php echo e($trx->status == 'draft' ? 'bg-gray-100 text-gray-600' : ''); ?>

                            <?php echo e($trx->status == 'rejected' ? 'bg-rose-100 text-rose-700' : ''); ?>

                        "><?php echo e(ucfirst($trx->status)); ?></span>
                    </td>
                    <td class="py-4 px-6 text-right">
                        <span class="text-sm font-bold text-rose-600">-Rp <?php echo e(number_format($trx->amount, 0, ',', '.')); ?></span>
                    </td>
                    <td class="py-4 px-6 text-center">
                        <a href="<?php echo e(route('expense.show', $trx)); ?>" class="inline-flex items-center px-3 py-1.5 bg-gray-100 text-gray-600 text-xs font-semibold rounded-lg hover:bg-rose-100 hover:text-rose-700 transition">
                            Lihat
                        </a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" class="py-16 text-center">
                        <div class="flex flex-col items-center">
                            <div class="w-20 h-20 bg-rose-100 rounded-2xl flex items-center justify-center mb-4">
                                <svg class="w-10 h-10 text-rose-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"/>
                                </svg>
                            </div>
                            <p class="text-gray-500 font-semibold mb-1">Belum ada transaksi pengeluaran</p>
                            <p class="text-gray-400 text-sm mb-4">Catat pengeluaran pertama Anda</p>
                            <a href="<?php echo e(route('expense.create')); ?>" class="btn-primary inline-flex items-center px-5 py-2.5 text-white font-semibold rounded-xl">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                                </svg>
                                Tambah Pengeluaran
                            </a>
                        </div>
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <?php if(isset($transactions) && $transactions->hasPages()): ?>
    <div class="px-6 py-4 border-t border-gray-100 bg-gray-50/50"><?php echo e($transactions->withQueryString()->links()); ?></div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\inventaris-bumdes-somogede\resources\views/expense/index.blade.php ENDPATH**/ ?>