

<?php $__env->startSection('title', 'Detail Pemasukan'); ?>
<?php $__env->startSection('subtitle', $income->transaction_number); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto">
    <!-- Back Button -->
    <a href="<?php echo e(route('income.index')); ?>" class="inline-flex items-center text-gray-400 hover:text-gray-600 mb-6 group">
        <svg class="w-5 h-5 mr-2 group-hover:-translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
        </svg>
        <span class="font-medium">Kembali ke Daftar</span>
    </a>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Main Info -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Transaction Card -->
            <div class="bg-white rounded-2xl shadow-soft border border-gray-100/50 overflow-hidden">
                <div class="p-6 border-b border-gray-100 bg-gradient-to-r from-blue-50 to-white">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <div class="w-14 h-14 bg-gradient-to-br from-blue-400 to-blue-600 rounded-xl flex items-center justify-center mr-4 shadow-lg shadow-blue-200/50">
                                <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                            </div>
                            <div>
                                <h2 class="text-xl font-bold text-gray-800"><?php echo e($income->transaction_number); ?></h2>
                                <p class="text-sm text-gray-400"><?php echo e($income->date->format('d F Y')); ?></p>
                            </div>
                        </div>
                        <?php
                            $statusColors = [
                                'draft' => 'bg-gray-100 text-gray-700',
                                'pending' => 'bg-amber-100 text-amber-700',
                                'approved' => 'bg-emerald-100 text-emerald-700',
                                'rejected' => 'bg-rose-100 text-rose-700',
                            ];
                            $statusLabels = [
                                'draft' => 'Draft',
                                'pending' => 'Menunggu',
                                'approved' => 'Disetujui',
                                'rejected' => 'Ditolak',
                            ];
                        ?>
                        <span class="px-4 py-2 <?php echo e($statusColors[$income->status]); ?> text-sm font-bold rounded-xl uppercase">
                            <?php echo e($statusLabels[$income->status]); ?>

                        </span>
                    </div>
                </div>

                <div class="p-6">
                    <!-- Amount -->
                    <div class="mb-6 p-4 bg-gradient-to-r from-blue-50 to-indigo-50 rounded-xl">
                        <p class="text-sm text-gray-500 mb-1">Jumlah Pemasukan</p>
                        <p class="text-3xl font-bold text-blue-600">Rp <?php echo e(number_format($income->amount, 0, ',', '.')); ?></p>
                    </div>

                    <!-- Details Grid -->
                    <div class="grid grid-cols-2 gap-6">
                        <div>
                            <p class="text-sm text-gray-400 mb-1">Kategori</p>
                            <p class="font-semibold text-gray-800"><?php echo e($income->category->name ?? '-'); ?></p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-400 mb-1">Unit Usaha</p>
                            <p class="font-semibold text-gray-800"><?php echo e($income->businessUnit->name ?? '-'); ?></p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-400 mb-1">Sumber</p>
                            <p class="font-semibold text-gray-800"><?php echo e($income->source ?? '-'); ?></p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-400 mb-1">No. Referensi</p>
                            <p class="font-semibold text-gray-800"><?php echo e($income->reference ?? '-'); ?></p>
                        </div>
                    </div>

                    <!-- Description -->
                    <div class="mt-6 pt-6 border-t border-gray-100">
                        <p class="text-sm text-gray-400 mb-2">Keterangan</p>
                        <p class="text-gray-700"><?php echo e($income->description); ?></p>
                    </div>

                    <!-- Attachment -->
                    <?php if($income->attachment): ?>
                    <div class="mt-6 pt-6 border-t border-gray-100">
                        <p class="text-sm text-gray-400 mb-3">Lampiran</p>
                        <a href="<?php echo e(Storage::url($income->attachment)); ?>" target="_blank" 
                           class="inline-flex items-center px-4 py-3 bg-gray-50 hover:bg-gray-100 rounded-xl transition group">
                            <svg class="w-8 h-8 text-gray-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                            </svg>
                            <div>
                                <p class="font-medium text-gray-700 group-hover:text-primary-600">Lihat Lampiran</p>
                                <p class="text-xs text-gray-400">Klik untuk membuka</p>
                            </div>
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Actions Card -->
            <div class="bg-white rounded-2xl shadow-soft border border-gray-100/50 p-6">
                <h3 class="font-bold text-gray-800 mb-4">Aksi</h3>
                <div class="space-y-3">
                    <?php if($income->status === 'draft'): ?>
                    <a href="<?php echo e(route('income.edit', $income)); ?>" 
                       class="flex items-center justify-center w-full px-4 py-3 bg-gray-100 text-gray-700 font-semibold rounded-xl hover:bg-gray-200 transition">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                        </svg>
                        Edit
                    </a>
                    <form action="<?php echo e(route('income.submit', $income)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="flex items-center justify-center w-full px-4 py-3 btn-primary text-white font-semibold rounded-xl">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            Submit untuk Approval
                        </button>
                    </form>
                    <form id="delete-form-income-<?php echo e($income->id); ?>" action="<?php echo e(route('income.destroy', $income)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="button" onclick="confirmDeleteModal('delete-form-income-<?php echo e($income->id); ?>', 'Yakin ingin menghapus transaksi pemasukan <?php echo e($income->transaction_number); ?>?')" 
                                class="flex items-center justify-center w-full px-4 py-3 border-2 border-rose-200 text-rose-600 font-semibold rounded-xl hover:bg-rose-50 transition">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                            </svg>
                            Hapus
                        </button>
                    </form>
                    <?php endif; ?>

                    <?php if($income->status === 'pending' && auth()->user()->canApprove()): ?>
                    <form action="<?php echo e(route('income.approve', $income)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="flex items-center justify-center w-full px-4 py-3 bg-emerald-500 text-white font-semibold rounded-xl hover:bg-emerald-600 transition">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                            </svg>
                            Setujui
                        </button>
                    </form>
                    <form action="<?php echo e(route('income.reject', $income)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="flex items-center justify-center w-full px-4 py-3 border-2 border-rose-200 text-rose-600 font-semibold rounded-xl hover:bg-rose-50 transition">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                            </svg>
                            Tolak
                        </button>
                    </form>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Info Card -->
            <div class="bg-white rounded-2xl shadow-soft border border-gray-100/50 p-6">
                <h3 class="font-bold text-gray-800 mb-4">Informasi</h3>
                <div class="space-y-4">
                    <div>
                        <p class="text-xs text-gray-400 mb-1">Dibuat oleh</p>
                        <p class="font-medium text-gray-700"><?php echo e($income->createdBy->name ?? '-'); ?></p>
                    </div>
                    <div>
                        <p class="text-xs text-gray-400 mb-1">Tanggal Input</p>
                        <p class="font-medium text-gray-700"><?php echo e($income->created_at->format('d M Y, H:i')); ?></p>
                    </div>
                    <?php if($income->approved_at): ?>
                    <div>
                        <p class="text-xs text-gray-400 mb-1">Disetujui oleh</p>
                        <p class="font-medium text-gray-700"><?php echo e($income->approvedBy->name ?? '-'); ?></p>
                    </div>
                    <div>
                        <p class="text-xs text-gray-400 mb-1">Tanggal Disetujui</p>
                        <p class="font-medium text-gray-700"><?php echo e($income->approved_at->format('d M Y, H:i')); ?></p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\inventaris-bumdes-somogede\resources\views/income/show.blade.php ENDPATH**/ ?>